' Ten kod pochodzi z ksiki "ASP.NET 2.0. Gotowe rozwizania" autorstwa
' Imara Spaanjaarsa, Paula Wiltona and Shawna Livermore, wydanej przez Wrox.
' Polska edycja: Wydawnictwo Helion.
' Copyright 2006 by Wiley Publishing Inc.
' Informacja o tej ksice jest dostpna na stronie www.wrox.com.  
' Odwied p2p.wrox.com aby podyskutowa o tym kodzie na forach Wrox.

Imports System.Data

''' <summary>
''' Klasa ContentManager odpowiada za dodawanie i odczytywanie komentarzy zwizanych z bdami.
''' </summary>
Public Class CommentManager

#Region "Konstruktor(y)"

  Private Sub New()
    ' Ukryj konstruktor, poniewa skadniki klasy maj dostp wspdzielony.
  End Sub

#End Region

#Region "Metody publiczne"

  ''' <summary>
  ''' Zwraca list komentarzy na temat danego bdu jako DataSet.
  ''' </summary>
  ''' <param name="bugId">Identyfikator bdu w bazie danych.</param>
  ''' <returns>Obiekt DataSet ze szczegami komentarzy, w tym Id, Body, CommentDate oraz identyfikator i nazw czonka zespou ktry utworzy komentarz.</returns>
  ''' <remarks></remarks>
  Public Shared Function GetCommentList(ByVal bugId As Integer) As DataSet
    Return CommentManagerDB.GetCommentList(bugId)
  End Function

  ''' <summary>
  ''' Wstawia do bazy danych nowy komentarz zwizany z przesanym identyfikatorm obiektu Bug.
  ''' </summary>
  ''' <param name="bugId">Identyfikator obiektu Bug w bazie danych.</param>
  ''' <param name="theBody">Tekst komentarza.</param>
  ''' <param name="theMemberId">Identyfikator czonka zespou, ktry utworzy komentarz.</param>
  Public Shared Sub InsertComment(ByVal bugId As Integer, ByVal theBody As String, ByVal theMemberId As Guid)
    CommentManagerDB.InsertComment(bugId, theBody, theMemberId)
  End Sub

#End Region

End Class
